<div>

    <div class="p-4 bg-white block sm:flex items-center justify-between dark:bg-gray-800 dark:border-gray-700">
        <div class="w-full mb-1">
            <div class="mb-4">
                <h1 class="text-xl font-semibold text-gray-900 sm:text-2xl dark:text-white">@lang('modules.report.duePaymentsReceivedReport')</h1>
            </div>
            <div class="items-center justify-between block sm:flex ">
                <div class="lg:flex items-center mb-4 sm:mb-0">
                    <form class="sm:pr-3" action="#" method="GET">

                        <div class="lg:flex gap-2 items-center">
                            <x-select id="dateRangeType" class="block w-fit" wire:model="dateRangeType"
                                wire:change="setDateRange">
                                <option value="today">@lang('app.today')</option>
                                <option value="currentWeek">@lang('app.currentWeek')</option>
                                <option value="lastWeek">@lang('app.lastWeek')</option>
                                <option value="last7Days">@lang('app.last7Days')</option>
                                <option value="currentMonth">@lang('app.currentMonth')</option>
                                <option value="lastMonth">@lang('app.lastMonth')</option>
                                <option value="currentYear">@lang('app.currentYear')</option>
                                <option value="lastYear">@lang('app.lastYear')</option>
                            </x-select>

                            <x-select wire:model.live="filterCustomer" class="block w-fit min-w-[200px]">
                                <option value="">@lang('app.showAll') @lang('modules.customer.name')</option>
                                @foreach($customers ?? [] as $customer)
                                    <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                @endforeach
                            </x-select>

                            <div id="date-range-picker" class="flex flex-col w-full gap-2 sm:flex-row">
                                <div class="relative flex-1">
                                    <div class="absolute inset-y-0 flex items-center pointer-events-none start-0 ps-3">
                                        <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true"
                                            xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                            <path
                                                d="M20 4a2 2 0 0 0-2-2h-2V1a1 1 0 0 0-2 0v1h-3V1a1 1 0 0 0-2 0v1H6V1a1 1 0 0 0-2 0v1H2a2 2 0 0 0-2 2v2h20V4ZM0 18a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V8H0v10Zm5-8h10a1 1 0 0 1 0 2H5a1 1 0 0 1 0-2Z" />
                                        </svg>
                                    </div>
                                    <x-datepicker wire:model.live='startDate' placeholder="@lang('app.selectStartDate')" class="pl-10" />
                                </div>
                                <span class="self-center hidden text-gray-500 sm:block">@lang('app.to')</span>
                                <div class="relative flex-1">
                                    <div class="absolute inset-y-0 flex items-center pointer-events-none start-0 ps-3">
                                        <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true"
                                            xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                            <path
                                                d="M20 4a2 2 0 0 0-2-2h-2V1a1 1 0 0 0-2 0v1h-3V1a1 1 0 0 0-2 0v1H6V1a1 1 0 0 0-2 0v1H2a2 2 0 0 0-2 2v2h20V4ZM0 18a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V8H0v10Zm5-8h10a1 1 0 0 1 0 2H5a1 1 0 0 1 0-2Z" />
                                        </svg>
                                    </div>
                                    <x-datepicker wire:model.live='endDate' placeholder="@lang('app.selectEndDate')" class="pl-10" />
                                </div>
                            </div>
                        </div>
                    </form>
                </div>

                 <a href="javascript:;" wire:click='exportReport'
                class="inline-flex items-center  w-1/2 px-3 py-2 text-sm font-medium text-center text-gray-900 bg-white border border-gray-300 rounded-lg hover:bg-gray-100 focus:ring-4 focus:ring-primary-300 sm:w-auto dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-700">
                    <svg class="w-5 h-5 mr-2 -ml-1" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M6 2a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V7.414A2 2 0 0 0 15.414 6L12 2.586A2 2 0 0 0 10.586 2zm5 6a1 1 0 1 0-2 0v3.586l-1.293-1.293a1 1 0 1 0-1.414 1.414l3 3a1 1 0 0 0 1.414 0l3-3a1 1 0 0 0-1.414-1.414L11 11.586z" clip-rule="evenodd"/></svg>
                    @lang('app.export')
                </a>

            </div>
        </div>

    </div>


    <div class="flex flex-col">
        <div class="overflow-x-auto">
            <div class="inline-block min-w-full align-middle">
                <div class="overflow-hidden shadow">

                    <table class="w-full ">
                        <thead class="bg-gray-100 dark:bg-gray-700">
                            <tr>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium ltr:text-left rtl:text-right text-gray-500 uppercase dark:text-gray-400">
                                    @lang('modules.customer.name')
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium ltr:text-left rtl:text-right text-gray-500 uppercase dark:text-gray-400">
                                    @lang('modules.order.amount')
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium ltr:text-left rtl:text-right text-gray-500 uppercase dark:text-gray-400">
                                    @lang('modules.order.paymentMethod')
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium ltr:text-left rtl:text-right text-gray-500 uppercase dark:text-gray-400">
                                    @lang('modules.order.orderNumber')
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium ltr:text-left rtl:text-right text-gray-500 uppercase dark:text-gray-400">
                                    @lang('app.dateTime')
                                </th>

                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200 dark:bg-gray-800 dark:divide-gray-700" wire:key='outstanding-payment-list-{{ microtime() }}'>

                            @forelse ($payments as $payment)
                                <tr class="hover:bg-gray-100 dark:hover:bg-gray-700" wire:key='payment-{{ $payment->id . rand(1111, 9999) . microtime() }}' wire:loading.class.delay='opacity-10'>
                                    <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white">
                                        {{ $payment->order->customer->name ?? '--' }}
                                    </td>
                                    <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white">
                                        {{ currency_format($payment->due_amount_received, restaurant()->currency_id) }}
                                    </td>
                                    <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white">
                                        @lang('modules.order.' . $payment->payment_method)
                                    </td>
                                    <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white">
                                        <a href="javascript:;" class="underline underline-offset-2 decoration-dotted" wire:click="$dispatch('showOrderDetail', { id: {{ $payment->order->id }} })">
                                            {{ $payment->order->show_formatted_order_number ?? $payment->order->order_number ?? '--' }}
                                        </a>
                                    </td>
                                    <td class="py-2.5 px-4 text-sm text-gray-900 whitespace-nowrap dark:text-white">
                                        {{ $payment->created_at->timezone(timezone())->format(dateFormat() . ' ' . timeFormat()) }}
                                    </td>
                                    
                                </tr>
                            @empty
                                <tr class="hover:bg-gray-100 dark:hover:bg-gray-700">
                                    <td colspan="6" class="py-4 px-4 text-center text-gray-500 dark:text-gray-400">
                                        @lang('messages.noPaymentFound')
                                    </td>
                                </tr>
                            @endforelse

                            @if ($totalAmount > 0)
                                <tr class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                    <td class="py-2.5 px-4 text-base text-gray-900 dark:text-white" colspan="1">
                                        @lang('modules.order.total')
                                    </td>
                                    <td class="py-2.5 px-4 text-base text-gray-900 dark:text-white">
                                        {{ currency_format($totalAmount, restaurant()->currency_id) }}
                                    </td>
                                    <td colspan="4"></td>
                                </tr>
                            @endif

                        </tbody>
                    </table>


                </div>
            </div>
        </div>
    </div>
</div>
