<div>
    @assets
    <script src="{{ asset('vendor/pikaday.js') }}" defer></script>
    <link rel="stylesheet" type="text/css" href="{{ asset('vendor/pikaday.css') }}">
    @endassets

    <div class="p-4 bg-white block  dark:bg-gray-800 dark:border-gray-700">
        <div class="w-full mb-4">
            <h1 class="text-xl font-semibold text-gray-900 sm:text-2xl dark:text-white">@lang('menu.reservations')</h1>
        </div>

        <div class="items-center justify-between block sm:flex bg-gray-50 dark:bg-gray-700 p-4 rounded-lg mb-4">
            <div class="lg:flex items-center mb-4 sm:mb-0">
                <form class="sm:pr-3" action="#" method="GET">
                    <div class="lg:flex gap-2 items-center">
                        <x-select id="dateRangeType" class="block w-fit" wire:model="dateRangeType"
                            wire:change="setDateRange">
                            <option value="today">@lang('app.today')</option>
                            <option value="nextWeek">@lang('app.nextWeek')</option>
                            <option value="currentWeek">@lang('app.currentWeek')</option>
                            <option value="lastWeek">@lang('app.lastWeek')</option>
                            <option value="last7Days">@lang('app.last7Days')</option>
                            <option value="currentMonth">@lang('app.currentMonth')</option>
                            <option value="lastMonth">@lang('app.lastMonth')</option>
                            <option value="currentYear">@lang('app.currentYear')</option>
                            <option value="lastYear">@lang('app.lastYear')</option>
                        </x-select>

                        <div class="flex items-center mt-2 md:mt-0 w-full">
                            <x-datepicker wire:model.change="startDate" id="datepicker-range-start" placeholder="@lang('app.selectStartDate')" />
                            <span class="mx-4 text-gray-500">@lang('app.to')</span>
                            <x-datepicker wire:model.live="endDate" id="datepicker-range-end" placeholder="@lang('app.selectEndDate')" />
                        </div>
                    </div>
                </form>

                <x-input class="block w-full md:w-1/3 mt-2 md:mt-0" type="text" wire:model.live.debounce.400ms="search" placeholder="{{ __('placeholders.searchCustomers') }}" />
            </div>

            @if(user_can('Create Reservation') && in_array('Table Reservation', restaurant_modules()) && restaurant()->enable_admin_reservation)
            <x-button type='button' wire:click="$set('showAddReservation', true)">
                @lang('modules.reservation.newReservation')</x-button>
            @endif
        </div>

        <div class="flex flex-col my-4">

            <!-- Card Section -->
            <div class="space-y-4">
                <div class="grid sm:grid-cols-3 gap-3 sm:gap-4">
                    @forelse ($reservations as $item)
                    @livewire('reservations.reservation-card', ['reservation' => $item], key('reservation-' . $item->id
                    . microtime()))
                    @empty
                    <div class="text-center col-span-full">
                        <div class="flex flex-col items-center">
                            <svg class="w-12 h-12 text-gray-400 mb-3" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 4H5a2 2 0 00-2 2v14a2 2 0 002 2h14a2 2 0 002-2V6a2 2 0 00-2-2zm-3-2v4M8 2v4m-5 4h18m-7 4h-4v4h4v-4z"/>
                            </svg>
                            <p class="text-gray-500 dark:text-gray-400">@lang('messages.noReservationsFound')</p>
                        </div>
                    </div>
                    @endforelse
                </div>
            </div>
            <!-- End Card Section -->

        </div>

    </div>

    <x-right-modal wire:model.live="showAddReservation">
        <x-slot name="title">
            {{ __("modules.reservation.newReservation") }}
        </x-slot>

        <x-slot name="content">
            @if ($showAddReservation)
                <livewire:forms.new-reservation />
            @endif
        </x-slot>
    </x-right-modal>



</div>
