<div>

    <form wire:submit="submitForm">

    <div class="flex flex-col">
        <div class="overflow-x-auto">
            <div class="inline-block min-w-full align-middle">
                <div class="overflow-hidden shadow">
                    <table class="min-w-full divide-y divide-gray-200 table-fixed dark:divide-gray-600">
                        <thead class="bg-gray-100 dark:bg-gray-700">
                            <tr>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">
                                    @lang('modules.reservation.slotType')
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">
                                    @lang('modules.reservation.timeStart')
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">
                                    @lang('modules.reservation.timeEnd')
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">
                                    @lang('modules.reservation.timeSlotDifference')
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium text-gray-500 uppercase dark:text-gray-400 text-right">
                                    @lang('modules.reservation.available')
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200 dark:bg-gray-800 dark:divide-gray-700" wire:key='menu-item-list-{{ microtime() }}'>

                            @forelse ($dayTimeSlots as $key => $item)
                            <tr class="hover:bg-gray-100 dark:hover:bg-gray-700" wire:key='menu-item-{{ $item->id . microtime() }}' wire:loading.class.delay='opacity-10'>
                                <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white">{{
                                    __('modules.reservation.' . $item->slot_type) }}

                                    @if (!$timeSlotAvailable[$key])
                                    <br>
                                    <span
                                     @class(['bg-red-100 text-red-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded dark:bg-gray-700 dark:text-red-400 border border-red-400'])>
                                         @lang('modules.reservation.unavailable')
                                    </span>
                                    @endif
                                </td>
                                <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white">
                                    <div class="relative w-45" x-on:input="$wire.set('timeStart.{{ $key }}', $event.detail)">
                                        <x-time-picker value="{{ $timeStart[$key] ?? '' }}" class="text-sm py-1.5 px-2" />
                                    </div>
                                </td>
                                <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white">
                                    <div class="relative w-45" x-on:input="$wire.set('timeEnd.{{ $key }}', $event.detail)">
                                        <x-time-picker value="{{ $timeEnd[$key] ?? '' }}" class="text-sm py-1.5 px-2" />
                                    </div>
                                </td>
                                <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white">
                                    <div class="relative w-32">
                                        <div class="absolute inset-y-0 end-0 top-0 flex items-center pe-3.5 pointer-events-none text-sm dark:text-gray-400">
                                            @lang('app.minutes')
                                        </div>

                                        <input type="number" wire:model.live='timeSlotDifference.{{ $key }}' step='15' min='0' max='60' class="bg-gray-50 border leading-none border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-gray-500 focus:border-gray-500 block w-full p-2.5 pe-10 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-gray-500 dark:focus:border-gray-500"  />

                                    </div>
                                </td>

                                <td class="py-2.5 px-4 space-x-2 whitespace-nowrap text-right">
                                    <x-checkbox name="timeSlotAvailable.{{ $key }}" id="timeSlotAvailable.{{ $key }}" wire:model='timeSlotAvailable.{{ $key }}'  />
                                </td>
                            </tr>
                            @empty
                            <tr class="hover:bg-gray-100 dark:hover:bg-gray-700">
                                <td class="py-2.5 px-4 space-x-6" colspan="5">
                                    @lang('messages.noItemAdded')
                                </td>
                            </tr>
                            @endforelse

                        </tbody>
                    </table>

                </div>

                <div class="mt-2">
                    <x-button>@lang('app.save')</x-button>
                </div>
            </div>
        </div>
    </div>

    </form>

</div>
