
<div>
    <div>

        <div class="p-4 bg-white block sm:flex items-center justify-between dark:bg-gray-800 dark:border-gray-700">
            <div class="w-full mb-1">
                <div class="mb-4">
                    <h1 class="text-xl font-semibold text-gray-900 sm:text-2xl dark:text-white">@lang('superadmin.menu.superadmin')</h1>
                </div>
                <div class="items-center justify-between block sm:flex ">
                    <div class="lg:flex items-center mb-4 sm:mb-0">
                        <form class="sm:pr-3" action="#" method="GET">
                            <label for="products-search" class="sr-only">Search</label>
                            <div class="relative w-48 mt-1 sm:w-64 xl:w-96">
                                <x-input id="menu_name" class="block mt-1 w-full" type="text" placeholder="{{ __('placeholders.searchStaffmember') }}" wire:model.live.debounce.500ms="search"  />
                            </div>
                        </form>
                    </div>

                    <div class="lg:inline-flex items-center gap-4">
                        @if (user_can('Create SuperAdmin'))
                            <x-button type='button' wire:click="$set('showAddMember', true)" >@lang('modules.staff.addStaff')</x-button>
                        @endif
                    </div>

                </div>


            </div>

        </div>

        <livewire:add-super-admin.super-admin-user-table :search='$search' key='superadmin-user-table-{{ microtime() }}' />


    </div>


    <x-right-modal wire:model.live="showAddMember">
        <x-slot name="title">
            {{ __("modules.staff.addStaff") }}
        </x-slot>

        <x-slot name="content">
            @livewire('forms.add-super-admin')
        </x-slot>
    </x-right-modal>

    <!-- Edit Superadmin Form -->
    @livewire('forms.edit-super-admin')
</div>
